// Copyright 1993-1995 by Jon Dart.  All Rights Reserved.

#ifndef _BOOK_ENTRY_H
#define _BOOK_ENTRY_H

#include "types.h"
#include "hashable.h"
#include "pool.h"
#include <malloc.h>

class Book_Entry : public Hashable
{
     // defines one entry in the opening book's hash table.

public:

     Book_Entry()
     {
     }

     Book_Entry( hash_t hc, byte rec, byte mv_indx,
	         BOOL last = FALSE);

     void init( hash_t hc, byte rec, byte mv_indx,
	        BOOL last = FALSE);
 
     // two entries are equivalent if they have the same hash code bytes.
     BOOL is_equal( const Hashable &c) const;
	    
     void *operator new (size_t size)
     {
	return allocator.allocate(size);
     }
    
     void *operator new (size_t, void *p)
     {
	return p;    
     }

     void operator delete( void *p )
     {
	allocator.free(p);    
     }
    
     static void freeAll( BOOL final )
     {
	allocator.freeAll(final);
     }

     hash_t hash_code() const
     {
        return my_hash_code;
     }
     
     byte get_move_index() const
     { 
	return move_index;
     }
     
     BOOL is_last() const;

     void set_last(BOOL b = TRUE);

     unsigned get_recommend() const;

     hash_t my_hash_code;
     byte move_index;
private:
     byte recommend;
     static Pool allocator;
};

#endif
